% DESCRIPTION:
%       subscript to cast loop variables
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 26th November 2010
%       last update - 2nd February 2011
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010, 2011 Bradley Treeby and Ben Cox

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>.

% cast variables used in time loop
if ~strcmp(data_cast, 'off')
    
    % update command line status
    disp(['  casting variables to ' data_cast ' type...']);

    % create list of variable names to cast
    switch kgrid.dim
        case 1
            cast_variables = {'ddx_k', 'shift_pos', 'shift_neg',...
                'abc_x', 'abc_x_alt',...
                'ux', 'p','c', 'dt',...
                'rho0', 'rho0_sg', 'rhox'};              
        case 2
            cast_variables = {'ddx_k_shift_pos', 'ddx_k_shift_neg', 'ddz_k_shift_pos', 'ddz_k_shift_neg',...
                'abc_x', 'abc_z', 'abc_x_alt', 'abc_z_alt',...
                'ux_r1', 'uz_r2', 'p','c', 'dt',...
                'rho0', 'rho0_r1', 'rho0_r2', 'rhox', 'rhoz'};
        case 3
            cast_variables = {'ddx_k_shift_pos', 'ddy_k_shift_pos', 'ddz_k_shift_pos', 'ddx_k_shift_neg', 'ddy_k_shift_neg', 'ddz_k_shift_neg',...
                'abc_x', 'abc_y', 'abc_z', 'abc_x_alt', 'abc_y_alt', 'abc_z_alt',...        
                'ux_r1', 'uy_r2', 'uz_r3', 'p','c', 'dt',...
                'rho0', 'rho0_r1', 'rho0_r2', 'rho0_r3', 'rhox', 'rhoy', 'rhoz'};          
    end
    
    % add sensor mask variables
    if use_sensor
        cast_variables = [cast_variables, {'sensor_mask_ind'}];
    end
    
    % additional variables only used in particular simulation types
    if ~time_rev && use_sensor
        if return_velocity
            switch kgrid.dim
                case 1
                    cast_variables = [cast_variables, {'sensor_data.p', 'sensor_data.ux'}];
                case 2
                    cast_variables = [cast_variables, {'sensor_data.p', 'sensor_data.ux', 'sensor_data.uz'}];
                case 3
                    cast_variables = [cast_variables, {'sensor_data.p', 'sensor_data.ux', 'sensor_data.uy', 'sensor_data.uz'}];
            end
        else
            cast_variables = [cast_variables, {'sensor_data'}];
        end
    elseif time_rev
        cast_variables = [cast_variables, {'sensor.time_reversal_boundary_data'}];
    end
    
    % additional variables only used if the medium is absorbing
    if strcmp(equation_of_state, 'absorbing')
        cast_variables = [cast_variables, {'absorb_param', 'dispers_param'}];
    elseif strcmp(equation_of_state, 'stokes')
        cast_variables = [cast_variables, {'absorb_param'}];
    end
    
    % additional variables only used if there is a time varying source term
    if p_source
        cast_variables = [cast_variables, {'ps_index', 'p_element_index', 'source.p'}];
    end    
    if u_source
        switch kgrid.dim
            case 1
                cast_variables = [cast_variables, {'us_index', 'u_element_index', 'source.ux'}];                
            case 2
                cast_variables = [cast_variables, {'us_index', 'u_element_index', 'source.ux', 'source.uz'}];
            case 3
                cast_variables = [cast_variables, {'us_index', 'u_element_index', 'source.ux', 'source.uy', 'source.uz'}];
        end
    end        
    
    % cast variables
    for cast_index = 1:length(cast_variables)
        eval([cast_variables{cast_index} ' = ' data_cast '(' cast_variables{cast_index} ');']);
    end
end